<?php

	# 		Forecast block
	# 		Namespace:		forecast
	#		Meteotemplate Block

	# 		v1.1 - Jan 29, 2016
	#			- added responsiveness
	#			- bug fixes
	# 		v2.0 - Feb 26, 2016
	#			- WxSim forecast added
	#			- Yr.No display clean-up - thanks Luc, Suriname
	# 		v2.1 - Apr 11, 2016
	#			- bug fix for cities with a space in the name for WU
	#		v2.3 - Nov 19, 2016
	#			- bug fix for WxSim rain
	# 		v2.4 - Dec 10, 2016
	# 			- hide select box when just one data source selected
	# 		v3.0 - Jan 6, 2017
	# 			- added DarkSky Forecast
	# 		v3.1 - Jan 7, 2017
	# 			- minor bug fixes
	# 		v3.2 - Jan 11, 2017
	# 			- minor bug fixes
	# 		v4.0 - Feb 22, 2017
	# 			- added MeteoBlue
	# 		v4.1 - Feb 27, 2017
	# 			- minor bug fixes
	# 		v4.2 - Mar 24, 2017
	# 			- added localization to MeteoBlue
	# 		v5.0 - May 4, 2017
	# 			- new icons for Weather Undergroung
	# 			- compatibility with HTTPS
	# 			- CSS improvements
	# 		v6.0 - May 14, 2017
	# 			- extension of WxSim forecast
	# 		v7.0 - Jul 1, 2017
	# 			- WxSIM language parser
	# 		v8.0 - Oct 22, 2017
	# 			- CSS improvements
	# 			- improved formatting
	# 		v9.0 - Jun 29, 2019
	# 			- compatibility fixes
	# 			- deleted WU
	# 		v9.1 - Jan 25, 2022
	# 			- converted to YrNo v2 api
	# 			- deleted Yahoo
	# 		v9.2 - Feb 19, 2022
	# 			- corrected wxSim forecast
	# 		v9.3 - Jul 12, 2022
	# 			- php 8.0 compatibility for wxSim forecast
	# 		v9.4 - Jul 14, 2022
	# 			- wxSim forecast: corrected array of icons/definitions


	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "First you need to go to your admin panel and use the blocks settings section to create the settings file.";
		die;
	}

	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];

	include("../../../config.php");
	include("../../../scripts/functions.php");

	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	$enabledForecasts = 0;
	/*if($showWUForecast){
		$enabledForecasts++;
	}*/
	if($showWxSimForecast){
		$enabledForecasts++;
	}
	if($showYahooForecast){
		$enabledForecasts++;
	}
	if($showyrNoForecast){
		$enabledForecasts++;
	}
	if($showDarkskyForecast){
		$enabledForecasts++;
	}
	if($showMeteoBlue){
		$enabledForecasts++;
	}

	if($showWxSimForecast){ // prepare textual forecast opener 
		//load plaintext file
		$plainText = fopen($pathPlainText, "r");
		$dataPlainRaw = fread($plainText,filesize($pathPlainText));
		fclose($plainText);
		
		$splitDays = preg_replace('![\n][\r|\n]+!s',"\n \n",$dataPlainRaw);
		$splitDays = preg_replace('![\r|\n]+ [\r|\n]+!s',"\t\t",$splitDays); 
		$splitDays .= "\t\t";  // make sure a delimiter is at the end too.
		$splitDays = preg_replace('|_|is','',$splitDays); // remove dashed line in front
		
		preg_match_all('!\t\s(.*):\s(.*)\t!Us',$splitDays,$matches); 
		
		$dayText = $matches[0];
		
		$periods = array();
		$descs = array();
		$temps = array();
		$uvs = array();
		$windSpeeds = array();
		$windGusts = array();
		
		foreach($dayText as $item){
			$from = array ("\n","\r",PHP_EOL);
			$item = str_replace ($from, "",$item);
			$format = explode(":",$item);
			$period = trim($format[0]);
			$desc = trim($format[1]);
			preg_match("/(High|Low) ([-]?[0-9]+)/",$desc,$matches);
			$temp = trim($matches[2]);
			preg_match("/UV index up to ([0-9]+)/",$desc,$matches);
			$uv = trim($matches[1]);
			preg_match("/Wind .* around ([0-9]+) ([^\s]*)/",$desc,$matches);
			$windSpeed = trim($matches[1]);
			$windSpeedUnits = trim($matches[2]);
			$windSpeedUnits = str_replace(".","",$windSpeedUnits);
			$windSpeedUnits = str_replace(",","",$windSpeedUnits);
			preg_match("/gusting to ([0-9]+) /",$desc,$matches);
			$gust = trim($matches[2]);
			$desc = preg_replace("/(High|Low) [-]?[0-9]+.[\s]?/","",$desc);
			$desc = preg_replace("/UV index up to [0-9]+.[\s]?/","",$desc);
			// try translating
			if($lang!="gb" && $lang!="us"){ // if not necessary, leave original... just in case :D
				include("wxSimTranslate.php"); 
			}	
			array_push($periods,$period);
			array_push($descs,$desc);
			array_push($temps,$temp);
			array_push($uvs,$uv);
			array_push($windSpeeds,$windSpeed);
			array_push($windGusts,$gust);
		}
	}

?>
	<style>
		<?php
			if($theme=="light"){
		?>
				.table th{
					color:black;
				}
		<?php
			}
		?>
		#wxSimInfoOpener{
			font-size: 2em;
			cursor: pointer;
			opacity: 0.8;
		}
		#wxSimInfoOpener:hover{
			opacity: 1;
		}

	</style>
	<div id="forecastContent" style="width:100%"></div>
	<br>
	<?php
		// hide the select box if only one forecast is enabled
		if($enabledForecasts>1){
	?>
		<select id="forecastSelector" class="button">
			<?php
				if($showyrNoForecast){
			?>
					<option value="yrNo">
						yr.No
					</option>
			<?php
				}
			?>
			<?php
				if($showDarkskyForecast){
			?>
					<option value="darkSky">
						DarkSky.net
					</option>
			<?php
				}
			?>
			<?php
				if($showMeteoBlue){
			?>
					<option value="meteoBlue">
						MeteoBlue
					</option>
			<?php
				}
			?>
			<?php
				if($showYahooForecast){
			?>
					<option value="yahoo">
						Yahoo
					</option>
			<?php
				}
			?>
			<?php
				if($showWxSimForecast){
			?>
					<option value="wxsim">
						WxSim
					</option>
			<?php
				}
			?>
		</select>
	<?php
		}
	?>
	<?php 
		if($showWxSimForecast){
	?>
			<div id="forecastWxSimText" title="WxSim">
				<?php
					$i = 0;
					while($i<count($periods)){
				?>
					<table class="table" style="width:98%;margin-left:auto;margin-right:auto">
						<tr>
							<th style="text-align:left;border-right: 1px solid #<?php echo $color_schemes[$design2]['700']?>" colspan="4">
								<?php 
									if (strpos($periods[$i], ' night') !== false) {
										$periods[$i] = strtolower(trim(str_replace(" night","",$periods[$i])));
										echo ucfirst(lang(strtolower($periods[$i]),'c'))." ".lang('night','l');
									}
									else{
										echo ucfirst(lang(strtolower($periods[$i]),'c'));
									}
									echo " / ";
									if (strpos($periods[($i+1)], ' night') !== false) {
										$periods[($i+1)] = strtolower(trim(str_replace(" night","",$periods[($i+1)])));
										echo ucfirst(lang(strtolower($periods[($i+1)]),'c'))." ".lang('night','l');
									}
									else{
										echo ucfirst(lang(strtolower($periods[($i+1)]),'c'));
									}
								?>
							</th>
						</tr>
						<tr>
							<td style="width:10%;text-align:center;padding-left:40px;padding-right:40px;border-right: 1px solid #<?php echo $color_schemes[$design2]['700']?>">
								<span style="font-size:2.2em">
									<?php echo $temps[$i]?>°
								</span>
							</td>
							<td style="width:10%;font-weight:bold">
								<div>
								<?php
									if($uvs[($i)]!=""){
										echo "<span class='mticon-uv tooltip' style='font-size:1.7em;vertical-align:middle;padding:3px' alt='' title='UV'></span><span style='vertical-align:middle;font-size:1.1em'><br>".$uvs[$i]."</span>";
									}
								?>
								</div>
							</td>
							<td style="width:10%;font-weight:bold">
								<div>
								<?php
									if($windSpeeds[($i)]!=""){
										echo "<span class='mticon-wind tooltip' style='font-size:1.7em;padding:3px' alt='' title='Wind'></span><br><span style='font-size:1em'>".$windSpeeds[$i]."</span> ".$windSpeedUnits;
									}
								?>
								</div>
							</td>
							<td style="text-align:left">
								<?php echo $descs[$i]?>
							</td>
						</tr>
						<tr>
							<td style="text-align:center;padding-left:40px;padding-right:40px">
								<span style="font-size:2.2em">
									<?php echo $temps[($i+1)]?><?php if($descs[($i+1)]!=""){ echo "°";}?>
								</span>
							</td>
							<td style="font-weight:bold">
								<div>
								<?php
									if($uvs[($i+1)]!=""){
										echo "<img src='".$pageURL.$path."icons/sun.png' style='width:25px;vertical-align:middle;padding:3px' alt='' class='tooltip' title='UV'><span style='vertical-align:middle;font-size:1.3em'><br>".$uvs[$i+1]."</span>";
									}
								?>
								</div>
							</td>
							<td style="font-weight:bold">
								<div>
								<?php
									if($windSpeeds[($i+1)]!=""){
										echo "<img src='".$pageURL.$path."icons/wind.png' style='width:25px;padding:3px' alt='' class='tooltip' title='Wind'><span style='font-size:1.3em'><br>".$windSpeeds[$i+1]."</span> ".$windSpeedUnits;
									}
								?>
								</div>
							</td>
							<td style="text-align:left">
								<?php echo $descs[($i+1)]?>
							</td>
						</tr>
					</table>
					<br>
				<?php
						$i = $i + 2;
					}
				?>
			</div>
			<script>
				dialogHeight = screen.height*0.8;
				dialogWidth = screen.width*0.8;
				$("#forecastWxSimText").dialog({
					modal: true,
					autoOpen: false,
					height: dialogHeight,
					width: dialogWidth
				});
				
			</script>
	<?php 
		}
	?>
	<script>
		updateForecast('<?php echo $defaultForecast?>');
		$("#forecastSelector").val("<?php echo $defaultForecast?>");
		$("#forecastSelector").change(function(){
			service = $(this).val();
			updateForecast(service)
		})
		function updateForecast(service){
			$.ajax({
				url : 'homepage/blocks/forecast/forecastAjax.php?service='+service+'&cache=<?php echo $forecastsCache?>',
				success : function (result) {
					$("#forecastContent").html(result);
					$("#moreYrNo").click(function(){
						var txt = $("#yrNoDetails").is(':visible') ? '<?php echo lang('more','l')?>' : '<?php echo lang('hide','l')?>';
						$("#yrNoDetails").slideToggle(800);
						$(this).text(txt);
					});
					$("#wxSimInfoOpener").click(function(){
						$("#forecastWxSimText").dialog('open');
					});
				},
			});
		}


	</script>
