<?php


	include("settings.php");

	$categories = explode(',',$categories);

	include("../../../config.php");
	include("../../../scripts/functions.php");
	include("../../../css/design.php");
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	$service = $_GET['service'];

	$weekDays = array(lang('sundayAbbr','c'),lang('mondayAbbr','c'),lang('tuesdayAbbr','c'),lang('wednesdayAbbr','c'),lang('thursdayAbbr','c'),lang('fridayAbbr','c'),lang('saturdayAbbr','c'));

	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];

	$themeColorBg = $theme=="dark" ? $color_schemes[$design]['800'] : $color_schemes[$design]['200'];
	$themeColorFont = $theme=="dark" ? "white" : "black";
	$themeColorBg2 = $theme=="dark" ? $color_schemes[$design]['700'] : $color_schemes[$design]['300'];
	$themeColorFont = $theme=="dark" ? "white" : "black";

	// NEW Yr.No. v2 api
	if($service=="yrNo"){
      	$cache = "cache/yrNo.txt";
		$yrNoLocation = explode(",",$yrNoLocation);
		$yrNoURL = 'https://api.met.no/weatherapi/locationforecast/2.0/compact?'.$yrNoLocation[1];
		//echo $yrNoURL."<br>";

		if(file_exists($cache)){
			if (time()-filemtime($cache) > 60 * $_GET['cache']) {
				unlink($cache);
			}
		}
		if(file_exists($cache)){
			$cached = fopen($cache, "r");
			$response_json_data = fread($cached,filesize($cache));
			fclose($cached);
		}
		else {
			$response_json_data = loadContent($yrNoURL,5);
			$cached = fopen($cache, "w");
			fwrite($cached, $response_json_data);
			fclose($cached);
		}

		$xmlYrNo = json_decode($response_json_data,true);
		$yrNoData = array();

		//$forecastCityName = $xmlYrNo['location']['name'];
		$forecastCityName = $yrNoLocation[0];

		//$numberItems = count($xmlYrNo['forecast']['tabular']['time']);
		$numberItems = count($xmlYrNo['properties']['timeseries']);
		//echo "numberItems=$numberItems<br>";
		//$tempUnitsYrNo = $xmlYrNo['forecast']['tabular']['time'][0]['temperature']['@attributes']['unit'];
		$tempUnitsYrNo = $xmlYrNo['properties']['meta']['units']['air_temperature'];
		$rainUnitsYrNo = $xmlYrNo['properties']['meta']['units']['precipitation_amount'];
		//$UTCoffset = $xmlYrNo['location']['timezone']['@attributes']['utcoffsetMinutes'];
		$UTCoffset = $sgn*($hrs*60+$mins)*60;	// secs
		$first = true;
		for($i=0;$i<$numberItems;$i++){
			$yrNoDataRow = array();
            $time = $xmlYrNo['properties']['timeseries'][$i]['time'];
			$timeTS = strtotime($time);
			$h = date("G",$timeTS-$UTCoffset);
			if (  isset($xmlYrNo['properties']['timeseries'][$i]['data']['next_6_hours']) && (($first || (($h % 6) == 0)) || !isset($xmlYrNo['properties']['timeseries'][$i]['data']['next_1_hours'])) )
			    {
                $d = date("Y/m/d H:i",$timeTS);
                $first = false;
				//echo "$d<br>";
				}
			else
				{continue;}
			$yrNoDataRow['period'] = intdiv($h,6);
			//echo "i=$i ".$yrNoDataRow['period']."<br>";

			$yrNoDataRow['fromdate'] = $timeTS;
			//echo "f".$yrNoDataRow['fromdate']." ";
            $yrNoDataRow['todate'] = $yrNoDataRow['fromdate']+6*3600;
			//echo "t".$yrNoDataRow['todate']."<br>";

			//$yrNoDataRow['condition'] = $xmlYrNo['forecast']['tabular']['time'][$i]['symbol']['@attributes']['name'];
			//$yrNoDataRow['symbolNumber'] = $xmlYrNo['forecast']['tabular']['time'][$i]['symbol']['@attributes']['number'];
			//$precipitation = $xmlYrNo['forecast']['tabular']['time'][$i]['precipitation']['@attributes']['value'];
			$precipitation = $xmlYrNo['properties']['timeseries'][$i]['data']['next_6_hours']['details']['precipitation_amount'];
			if($displayRainUnits=="mm")
			    {$yrNoDataRow['precipitation'] = $precipitation;}
			if($displayRainUnits=="in")
			    {$yrNoDataRow['precipitation'] = number_format(($precipitation * 0.039370),2,".","");}
			//$temperature = $xmlYrNo['forecast']['tabular']['time'][$i]['temperature']['@attributes']['value'];
			$temperature = $xmlYrNo['properties']['timeseries'][$i]['data']['instant']['details']['air_temperature'];
			$yrNoDataRow['temperature'] = number_format($temperature,0,".","");
			if($tempUnitsYrNo=="celsius" && $displayTempUnits=="C"){
				 $yrNoDataRow['temperature'] = number_format($temperature,0,".","");
			}
			if($tempUnitsYrNo!="celsius" && $displayTempUnits=="F"){
				 $yrNoDataRow['temperature'] = number_format($temperature,0,".","");
			}
			if($tempUnitsYrNo=="celsius" && $displayTempUnits=="F"){
				$temperature = $temperature*1.8 + 32;
				$yrNoDataRow['temperature'] = number_format($temperature,0,".","");
			}
			if($tempUnitsYrNo!="celsius" && $displayTempUnits=="C"){
				$temperature = ($temperature-32)/1.8;
				$yrNoDataRow['temperature'] = number_format($temperature,0,".","");
			}
			$yrNoDataRow['icon'] = $xmlYrNo['properties']['timeseries'][$i]['data']['next_6_hours']['summary']['symbol_code'];
			//echo $i." ".$yrNoDataRow['icon']."<br>";

			$forecasts[date("Ymd",$yrNoDataRow['fromdate'])][] = $yrNoDataRow;
		}
		/*if(count($forecasts)==0){
			unlink($cache);
		}*/
		$dataSource = "Data source: Yr.no<br>Weather forecast from Yr, delivered by the Norwegian Meteorological Institute and NRK.";
	}

	if($service=="wxsim"){
		$dataRaw = array();
		$fieldNames = "";
		$units = "";

		if (file_exists($pathLatest)) 
		    {
			$dataFile = fopen($pathLatest,"r");
			while(! feof($dataFile))
			    {
				if($fieldNames=="")
				    {$fieldNames = explode($fieldSeparator,fgets($dataFile));}
				else if($fieldNames!="" && $units=="")
				    {$units = explode($fieldSeparator,fgets($dataFile));}
				else
				    {
					$rowText = fgets($dataFile);
					if($decimalSeparator==",")
					    {
						$rowText = str_replace(" ,",";",$rowText);  // change field separator to semicolon
						$rowText = str_replace(",",".",$rowText);   // make sure decimal separator is a "."
					    }
					else
					    {$rowText = str_replace($fieldSeparator,";",$rowText);} // change field separator to semicolon
					$rowStringExploded = explode(";",$rowText);
					array_push($dataRaw,$rowStringExploded);
				    }
			    }
			fclose($dataFile);
		    }
		else 
		    {
			echo "WXSim CSV file not found";
			die;
		    }
		    
		//clean up variables
		$fieldNames = array_map('trim', $fieldNames);
		$units = array_map('trim', $units);
		$unitsT = $units[6];
		$dataTempUnits = str_replace("deg ","",$unitsT);
		$dataWindUnits = $units[12];
		$dataWindUnits = str_replace("mi/hr","mph",$dataWindUnits);
		$dataWindUnits = str_replace("km/hr","kmh",$dataWindUnits);
		$dataWindUnits = str_replace("m/s","ms",$dataWindUnits);
		$unitsR = $units[14];
		$dataRainUnits = str_replace("inches","in",$unitsR);
		$unitsSnow = $units[15];
		$unitsSnow = str_replace("inches","in",$unitsSnow);
		$unitsPRaw = $units[16];
		$unitsPRawSplit = explode(" ",$unitsPRaw);
		$unitsP = $unitsPRawSplit[0];

		//create cleaned up data array
		$data = array();
		$forecasts = 0;
		for($a=0;$a<count($dataRaw);$a++){
			$forecasts = $forecasts + 1;
			$currentRow = array();
			for($i=0;$i<count($dataRaw[$a]);$i++){
				$rawValue = $dataRaw[$a][$i];
				$rawValue = trim($rawValue);
				$currentRow[$fieldNames[$i]] = $rawValue;
			}
			if(array_key_exists(1,$dataRaw[$a])){
				$currentRow['timestamp'] = strtotime(trim($dataRaw[$a][0])."-".trim($dataRaw[$a][1])."-".trim($dataRaw[$a][2])." ".round(trim($dataRaw[$a][3]),0).":00");
				$extraData = formatCondition(trim($dataRaw[$a][4]));
				$currentRow['condition1'] = $extraData[0];
				$currentRow['icon'] = $extraData[1];
				//echo "a=$a dataraw[4]=".$dataRaw[$a][4]."dataraw[5]=".$dataRaw[$a][5]."<br>";
				//echo "extradata[0]=".$extraData[0]." extradata[1]=".$extraData[1]."<br>";
				if (trim($dataRaw[$a][5]) != "")
		    	   {
		    	   $extraData1 = formatCondition(trim($dataRaw[$a][5]));
		    	   $currentRow['icon'] = $extraData1[1];
		    	   //echo "extradata1[1]=".$extraData1[1]."<br><br>";
		    	   }
				$currentRow['timestamp'] = strtotime($currentRow['Year']."-".$currentRow['Month']."-".$currentRow['Day'])+$currentRow['Time']*60*60;
				if(date("i",$currentRow['timestamp'])==55){
					$currentRow['timestamp'] = $currentRow['timestamp'] + 5*60;
				}
				if(date("i",$currentRow['timestamp'])==25){
					$currentRow['timestamp'] = $currentRow['timestamp'] + 5*60;
				}
				$currentRow['DateTime'] = date("Y-m-d H:i",$currentRow['timestamp']);
				if($currentRow['Year']!=""){
					array_push($data,$currentRow);
				}
			}
		}

		// see if there is the 23h bug
		$previousTime = 0;
		$bug23 = false;
		$dataFinal = array();
		foreach($data as $outputRow){
			$currentTime = $outputRow['timestamp'];
			if($previousTime>$currentTime){
				$bug23 = true;
			}
			$previousTime = $outputRow['timestamp'];
		}
		if($bug23){
			foreach($data as $outputRow){
				if(date("H",$outputRow['timestamp'])==23){
					$outputRow['timestamp'] = $outputRow['timestamp']-24*60*60;
					$outputRow['DateTime'] = date("Y-m-d H:i",$outputRow['timestamp']);
				}
				$dataFinal[] = $outputRow;
			}
		}
		else{
			$dataFinal = $data;
		}

		$dataDays = array();
		foreach($dataFinal as $dataRow){
			$dataDays[date("Ymd",$dataRow['timestamp'])][] = $dataRow;
		}

		// categorize/group data
		$forecast = array();
		foreach($dataDays as $key=>$day){
			foreach($day as $keyDay=>$hour){
				foreach($categories as $category){
					$categoryExploded = explode("-",$category);
					if(date("H",$hour['timestamp'])>=$categoryExploded[0] && date("H",$hour['timestamp'])<$categoryExploded[1]){
						$forecast[$key][$category][] = $hour;
					}
				}
			}
		}
		$dataSource = $wxSimString;
	}

	if($service=="yrNo"){
		$startline = true;
		$line = 0;  // init line number
		$forecastStr = "<h2>".$forecastCityName."</h2><table style='width:98%;margin:0 auto'>";
		foreach($forecasts as $day){
            foreach($day as $hour){
                if($startline) {
                    $startline = false;
                    $line++;
                    if($line == 6) {
                        $forecastStr = $forecastStr."</tbody></table><div class='details' id='yrNoDetails' style='margin-top:20px'><table style='width:98%;margin:0 auto'>";
                    }
					if($hour['period'] == 0 and $hour['fromdate'] >= 6) {
                        $printdate = 'todate';
                    } else {
                        $printdate = 'fromdate';
                    }
                    // print date at the left
                    $forecastStr = $forecastStr."<tr style='background:#".$themeColorBg.";color:".$themeColorFont."'><td style='text-align:left;padding-left:20px'><span style='font-size:1.3em;font-variant:small-caps;font-weight:bold'>".$weekDays[date("w",$hour[$printdate])]."</span><br>".date("j",$hour[$printdate])." ".lang("month".date("n",$hour[$printdate])."short","c")."</td>";
                    for ($i = 0; $i < $hour['period']; $i++) {  // insert blank space at left when needed
                        $forecastStr = $forecastStr."<td style='width:20%'></td>";
                    }
                }
                // print forecast
                $forecastStr = $forecastStr."<td style='width:20%'><div style='background:#".$themeColorBg2.";color:".$themeColorFont.";width:100%;text-align:center;font-size:0.8em;font-weight:bold'>".date("G",$hour['fromdate'])."-".date("G",$hour['todate'])." ".lang('hAbbr','l')."</div><img src='".$pageURL.$path."homepage/blocks/forecast/iconsYrNo/".$hour['icon'].".png' style='max-width:60px;width:100%' alt=''><br>".$hour['temperature']." °".$displayTempUnits."&nbsp;/&nbsp;".$hour['precipitation']." ".$displayRainUnits."</td>";
                if($hour['period'] == 3) {
                    $startline = true;
                    $forecastStr = $forecastStr."</tr>";
                }
            }
        }
        $forecastStr = $forecastStr."</tbody></table></div>";
        $forecastStr = $forecastStr."<span id='moreYrNo' data-opener='yrNoDetails'>".lang('more','l')."</span>";
	}

	if($service=="wxsim"){
		$forecastStr = "<table style='width:98%;margin:0 auto'><tr>";
		$forecastStr .= "<td style='width:20%;text-align:left'>";

		$forecastStr .= "</td><td style='text-align:center'>";
		$forecastStr .= "<h2>".$pageName."</h2>";
		$forecastStr .= "</td>";
		$forecastStr .= "<td style='width:20%;text-align:right'>";
		$forecastStr .= "<span class='mticon-summary' id='wxSimInfoOpener'></span>";
		$forecastStr .= "</td></tr></table>";
		$forecastStr .= "<br><table style='width:98%;margin:0 auto' class='table'><thead><tr><th></th>";
		for($i=0;$i<count($categories);$i++){
			$forecastStr .= "<th>".$categories[$i]."</th>";
		}
		$forecastStr .= "</tr></thead><tbody>";
		$dayCount = 0;
		foreach($forecast as $dayKey=>$dayForecast){
			if($dayCount>$maxDays){
			}
			else{
				$dayCount++;
				$dayKeyFormat = strtotime($dayKey);
				$dayKeyString = "<strong><span style='font-size:1.5em;padding-bottom:5px'>".date("j",$dayKeyFormat)."</span><br><span style='font-variant:small-caps;padding-left:2px'>".$weekDays[date("w",$dayKeyFormat)]."</span>";
				$forecastStr .= "<tr><td style='padding-left:10px;vertical-align:top;padding-top:3px'>".$dayKeyString."</td>";
				foreach($categories as $cat){
					$forecastStr .= "<td>";
					if(array_key_exists($cat,$forecast[$dayKey])){
						$catSplit = explode("-",$cat);
						if($catSplit[0]<6 || $catSplit[0]>17){
							$dayNight = "N";
						}
						else{
							$dayNight = "D";
						}
						$result = periodSumup($forecast[$dayKey][$cat]);
						$forecastStr .= "<img src='homepage/blocks/forecast/iconsWxSim/".$result['icon'].$dayNight.".png' style='max-width:60px;width:100%' alt=''>";
						$forecastStr .= "<br><strong>";
						$forecastStr .= $result['T']."°".$displayTempUnits;
						$forecastStr .= "<br>".$result["rain"]." ".$displayRainUnits."</strong>";
						$forecastStr .= "<div class='WxSimDetails details'>";
						$forecastStr .= $result["Tmax"]." / ".$result["Tmin"]."°".$displayTempUnits;
						$forecastStr .= "<br>".$result["H"]." %";
						$forecastStr .= "<br>".$result["W"]." ".unitFormatter($displayWindUnits);
						$forecastStr .= "</div>";
					}
					$forecastStr .= "</td>";
				}
				$forecastStr .= "</tr>";
			}
		}
		$forecastStr .= "</tbody></table>";
		$forecastStr .= "<div class='WxSimDetails details'><br>";
		$forecastStr .= "<table style='width:98%;margin:0 auto' class='table'>";
		$forecastStr .= "<tbody>";
		$dayCount = 0;
		foreach($forecast as $dayKey=>$dayForecast){
			$dayCount++;
			if($dayCount<=$maxDays+1){

			}
			else{
				$dayKeyFormat = strtotime($dayKey);
				$dayKeyString = "<strong><span style='font-size:1.5em;padding-bottom:5px'>".date("j",$dayKeyFormat)."</span><br><span style='font-variant:small-caps;padding-left:2px'>".$weekDays[date("w",$dayKeyFormat)]."</span>";
				$forecastStr .= "<tr><td style='padding-left:10px;vertical-align:top;padding-top:3px'>".$dayKeyString."</td>";
				foreach($categories as $cat){
					$forecastStr .= "<td>";
					if(array_key_exists($cat,$forecast[$dayKey])){
						$catSplit = explode("-",$cat);
						if($catSplit[0]<6 || $catSplit[0]>17){
							$dayNight = "N";
						}
						else{
							$dayNight = "D";
						}
						$result = periodSumup($forecast[$dayKey][$cat]);
						$forecastStr .= "<img src='homepage/blocks/forecast/iconsWxSim/".$result['icon'].$dayNight.".png' style='max-width:60px;width:100%' alt=''>";
						$forecastStr .= "<br><strong>";
						$forecastStr .= $result['T']."°".$displayTempUnits;
						$forecastStr .= "<br>".$result["rain"]." ".$displayRainUnits."</strong><br>";
						$forecastStr .= $result["Tmax"]." / ".$result["Tmin"];
						$forecastStr .= "<br>".$result["H"]." %";
						$forecastStr .= "<br>".$result["W"]." ".$displayWindUnits;
					}
					$forecastStr .= "</td>";
				}
				$forecastStr .= "</tr>";
			}
		}
		$forecastStr .= "</tbody></table>";
		$forecastStr .= "</div>";
		$forecastStr .= "<span class='more' onclick=\"txt = $('.WxSimDetails').is(':visible') ? '".lang('more','l')."' : '".lang('hide','l')."';$('.WxSimDetails').slideToggle(800);$(this).text(txt)\">".lang('more','l')."</span>";
		$forecasts = $forecast;
	}

	if($service=="openWeather"){
		if($theme=="light"){
			$colorForecast = "#000";
		}
		else{
			$colorForecast = "#fff";
		}
		if($displayTempUnits=="C"){
			$FOpenWeatherUnits = "metric";
		}
		else{
			$FOpenWeatherUnits = "imperial";
		}
		if (empty($FOpenWeatherApiKey)) 
		    $FOpenWeatherApiKey = $fIOKey;
		$forecastStr = "<div id='openweathermap-widget-{$FOpenWeatherType}' style='width:{$FOpenWeatherWidth}px;margin:0 auto;text-align:center;'></div><script src='//openweathermap.org/themes/openweathermap/assets/vendor/owm/js/d3.min.js'></script><script>window.myWidgetParam ? window.myWidgetParam : window.myWidgetParam = [];  window.myWidgetParam.push({id: {$FOpenWeatherType},cityid: '{$FOpenWeatherLocation}',appid: '{$FOpenWeatherApiKey}',units: '{$FOpenWeatherUnits}',containerid: 'openweathermap-widget-{$FOpenWeatherType}',  });  (function() {var script = document.createElement('script');script.async = true;script.charset = \"utf-8\";script.src = \"//openweathermap.org/themes/openweathermap/assets/vendor/owm/js/weather-widget-generator.js\";var s = document.getElementsByTagName('script')[0];s.parentNode.insertBefore(script, s);  })();</script>";
		$dataSource = "openweathermap.org";
		$forecasts = array("","");
	}

	if($service=="meteoBlue"){
		if($lang=="cz"){
			$meteoblueLang = "cs";
		}
		else if($lang=="es"){
			$meteoblueLang = "es";
		}
		else if($lang=="de"){
			$meteoblueLang = "de";
		}
		else if($lang=="hu"){
			$meteoblueLang = "hu";
		}
		else if($lang=="pl"){
			$meteoblueLang = "pl";
		}
		else if($lang=="ro"){
			$meteoblueLang = "ro";
		}
		else if($lang=="sk"){
			$meteoblueLang = "sk";
		}
		else if($lang=="bg"){
			$meteoblueLang = "bg";
		}
		else if($lang=="fr"){
			$meteoblueLang = "fr";
		}
		else if($lang=="it"){
			$meteoblueLang = "it";
		}
		else if($lang=="nl"){
			$meteoblueLang = "nl";
		}
		else if($lang=="pt"){
			$meteoblueLang = "pt";
		}
		else if($lang=="rs"){
			$meteoblueLang = "sr";
		}
		else if($lang=="gr"){
			$meteoblueLang = "el";
		}
		else{
			$meteoblueLang = "en";
		}

		if($theme=="light"){
			$layout = "bright";
		}
		else{
			$layout = "dark";
		}
		if($displayTempUnits=="C"){
			$unitsT = "CELSIUS";
		}
		else{
			$unitsT = "FAHRENHEIT";
		}
		if($displayWindUnits=="kmh"){
			$unitsW = "KILOMETER_PER_HOUR";
		}
		else if($displayWindUnits=="ms"){
			$unitsW = "METER_PER_SECOND";
		}
		else if($displayWindUnits=="kt"){
			$unitsW = "KNOT";
		}
		else if($displayWindUnits=="mph"){
			$unitsW = "MILE_PER_HOUR";
		}
		$forecastStr = '<iframe src="https://www.meteoblue.com/'.$meteoblueLang.'/weather/widget/three/'.$meteoBlueLocation.'?geoloc=fixed&nocurrent=1&noforecast=0&days='.$meteoBlueDays.'&tempunit='.$unitsT.'&windunit='.$unitsW.'&layout='.$layout.'"  frameborder="0" scrolling="NO" allowtransparency="true" sandbox="allow-same-origin allow-scripts allow-popups" style="width:98%;height:520px;margin:0 auto"></iframe><div><!-- DO NOT REMOVE THIS LINK --><a href="https://www.meteoblue.com/en/weather/forecast/week/prague_czechia_3067696?utm_source=weather_widget&utm_medium=linkus&utm_content=three&utm_campaign=Weather%2BWidget" target="_blank">meteoblue</a></div></iframe>';
		$dataSource = "";
		$forecasts = array("","");
	}


	$forecastStr = $forecastStr."<div style='width:98%;margin:0 auto;text-align:center;font-size:0.7em;font-variant:small-caps;padding-top:10px'>".$dataSource."</div>";

	if(count($forecasts)==0){
		$forecastStr = "Forecast currently not available.";
	}


	echo $forecastStr;

if (!function_exists('loadContent'))
    {
    function loadContent($url,$timeout){
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
		curl_setopt($ch, CURLOPT_USERAGENT,"Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2228.0 Safari/537.36");
		$data = curl_exec($ch);
		curl_close($ch);

		if($data==""){
			$data = file_get_contents($url);
		}

		return $data;
	    }
    }
	function curl_get_contentsForecast($url){
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_URL, $url);
		$data = curl_exec($ch);
		curl_close($ch);
		return $data;
	}
	/*function formatCondition($condition){
		$originalText = array("SUNNY","CLEAR","HAZY SUN","M.CLEAR","FAIR","CLR-FAIR","M.SUNNY","FAIR-P.C.","FAIR-P.C","P.CLOUDY","P.-M.CLDY","P.-M.CLD","M.CLOUDY","M.C.-CLDY","M.C.-CLD","CLOUDY","DNS.OVCST","DNS.OVCS","CHNC. DRZL","CHNC. DRZ","CHNC. SHWR","CHNC. SHW","DRIZZLE","LIGHT RAIN","LIGHT RAI","PROB. DRZL","PROB. DRZ","PROB. SHWR","PROB. SHW","MOD. RAIN","HEAVY RAIN","HEAVY RAI","CH. RN/SNW","CH. RN/SN","CH. SNW/RN","CH. SNW/R","CHNC. SNOW","CHNC. SNO","LIGHT SNOW","LIGHT SNO","LT. RN/SNW","LT. RN/SN","LT. SNW/RN","LT. SNW/R","PR. RN/SNW","PR. RN/SN","PR. SNW/RN","PR. SNW/R","PROB. SNOW","PROB. SNO","PROB.SNOW","MOD. SNOW","SN. FLURRY","SN. FLURR","RAIN/SNOW","SNOW/RAIN","HEAVY SNOW","HEAVY SNO","HVY.SNW/RN","HVY.SNW/R","HVY.RN/SNW","HVY.RN/SN","CH. FRZ.RN","CH. FRZ.R","CH. RN/SLT","CH. RN/SL","CH. SLT/FR","CH. SLT/F","CH.SLT/MIX","CH.SLT/MI","CH.SLT/SNW","CH.SLT/SN","CHNC.SLEET","CHNC.SLEE","FRZ. DRZL","FRZ. RAIN","ICE STORM","LT. SLEET","LT.SLT/MIX","LT.SLT/MI","LT.SLT/SNW","LT.SLT/SN","PR. FRZ.RN","PR. FRZ.R","PR. RN/SLT","PR. RN/SL","PR.SLT/MIX","PR.SLT/MI","PR.SLT/SNW","PR.SLT/SN","PR. SLT/FR","PR. SLT/F","PROB.SLEET","PROB.SLEE","MOD. SLEET","MOD. SLEE","RAIN/SLEET","RAIN/SLEE","SLEET/MIX","SLEET/SNOW","SLEET/SNO","SLT/FRZ.RN","SLT/FRZ.R","BLIZZARD","HVY. SLEET","HVY. SLEE","HVY.SLT/MX","HVY.SLT/M","HVY.SLT/SN","HVY.SLT/S","LIGHT FOG","MOD. FOG","DENSE FOG","LIGHT DEW","MOD. DEW","HEAVY DEW","SCTD.FROST","SCTD.FROS","LT. FROST","MOD. FROST","MOD. FROS","HVY. FROST","HVY. FROS");
		$formattedText = array("sunny","clear","sunny with haze","mostly clear","mostly clear","mostly clear","mostly clear","partly cloudy","partly cloudy","partly cloudy","mostly cloudy","mostly cloudy","mostly cloudy","cloudy","cloudy","cloudy","overcast","overcast","chance of drizzle","chance of drizzle","chance of showers","chance of showers","drizzle","light rain","light rain","probable drizzle","probable drizzle","probable showers","probable showers","moderate rain","heavy rain","heavy rain","chance of rain or snow","chance of rain or snow","chance of snow or rain","chance of snow or rain","chance of snow","chance of snow","light snow","light snow","light rain or snow","light rain or snow","light snow or rain","light snow or rain","probable rain or snow","probable rain or snow","probable snow or rain","probable snow or rain","probable snow","probable snow","probable snow","moderate snow","snow flurries","snow flurries","rain or snow","snow or rain","heavy snow","heavy snow","heavy snow or rain","heavy snow or rain","heavy rain or snow","heavy rain or snow","chance of freezing rain","chance of freezing rain","chance of rain or sleet","chance of rain or sleet","chance of sleet","chance of sleet","chance of sleet or snow","chance of sleet or snow","chance of sleet","chance of sleet","freezing drizzle","freezing rain","ice storm","light sleet","light sleet","light sleet","light sleet or snow","light sleet or snow","probable freezing rain","probable freezing rain","probable rain or sleet","probable rain or sleet","probable sleet","probable sleet","probable sleet or snow","probable sleet or snow","probable sleet or freezing rain","probable sleet or freezing rain","probable sleet","probable sleet","moderate sleet","moderate sleet","rain or sleet","rain or sleet","sleet","sleet or snow","sleet or snow","sleet or freezing rain","sleet or freezing rain","snow and blizzard","heavy sleet","heavy sleet","heavy sleet","heavy sleet","heavy sleet","heavy sleet","light fog","moderate fog","dense fog","light dew","moderate dew","heavy dew","scattered frost","scattered frost","light frost","moderate frost","moderate frost","heavy frost","heavy frost");
		$icons = array("clear","clear","clearHaze","clearHaze","clearHaze","clearHaze","clearHaze","partlyCloudy","partlyCloudy","partlyCloudy","mostlyCloudy","mostlyCloudy","mostlyCloudy","cloudy","cloudy","cloudy","overcast","overcast","lightRainChances","lightRainChances","lightRainChances","lightRainChances","lightRainSnow","lightRainSnow","lightRainSnow","lightRainSnow","lightRainSnow","lightRainSnow","lightRainSnow","rain","heavyRain","heavyRain","rainSnowChances","rainSnowChances","rainSnowChances","rainSnowChances","snowChances","snowChances","lightSnow","lightSnow","rainSnow","rainSnow","rainSnow","rainSnow","rainSnow","rainSnow","rainSnow","rainSnow","snow","snow","snow","snow","snow","snow","rainSnow","rainSnow","heavySnow","heavySnow","heavyRainSnow","heavyRainSnow","heavyRainSnow","heavyRainSnow","rainSnowChances","rainSnowChances","rainSnowChances","rainSnowChances","lightRainChances","lightRainChances","rainSnowChances","rainSnowChances","lightRainChances","lightRainChances","rainSnow","rainSnow","rainSnow","lightRainSnow","lightRainSnow","lightRainSnow","rainSnow","rainSnow","rainSnow","rainSnow","rainSnow","rainSnow","lightRainSnow","lightRainSnow","rainSnow","rainSnow","rainSnow","rainSnow","lightRainSnow","lightRainSnow","lightRainSnow","lightRainSnow","rainSnow","rainSnow","rainSnow","rainSnow","rainSnow","rainSnow","rainSnow","blizzard","heavyRainSnow","heavyRainSnow","heavyRainSnow","heavyRainSnow","heavyRainSnow","heavyRainSnow","clearHaze","fog","fog","dew1","dew2","dew3","frost1","frost1","frost2","frost2","frost3","frost3");
		for($i=0;$i<count($originalText);$i++){
			if($condition==$originalText[$i]){
				$formatted = $formattedText[$i];
				$icon = $icons[$i];
			}
		}
		return array($formatted,$icon);
	}*/

	function formatCondition($condition)
		{
	 	$condArray = array ("SUNNY" => array("sunny","clear"),"CLEAR" => array("clear","clear"),"HAZY SUN" => array("sunny with haze","clearHaze"),"M.CLEAR" => array("mostly clear","clearHaze"),"FAIR" => array("mostly clear","clearHaze"),"CLR-FAIR" => array("mostly clear","clearHaze"),"M.SUNNY" => array("mostly clear","clearHaze"),"FAIR-P.C." => array("partly cloudy","partlyCloudy"),"FAIR-P.C" => array("partly cloudy","partlyCloudy"),"P.CLOUDY" => array("partly cloudy","partlyCloudy"),"P.-M.CLDY" => array("mostly cloudy","mostlyCloudy"),"P.-M.CLD" => array("mostly cloudy","mostlyCloudy"),"M.CLOUDY" => array("mostly cloudy","mostlyCloudy"),"M.C.-CLDY" => array("cloudy","cloudy"),"M.C.-CLD" => array("cloudy","cloudy"),"CLOUDY" => array("cloudy","cloudy"),"DNS.OVCST" => array("overcast","overcast"),"DNS.OVCS" => array("overcast","overcast"),"CHNC. DRZL" => array("chance of drizzle","lightRainChances"),"CHNC. DRZ" => array("chance of drizzle","lightRainChances"),"CHNC. SHWR" => array("chance of showers","lightRainChances"),"CHNC. SHW" => array("chance of showers","lightRainChances"),"DRIZZLE" => array("drizzle","lightRainSnow"),"LIGHT RAIN" => array("light rain","lightRainSnow"),"LIGHT RAI" => array("light rain","lightRainSnow"),"PROB. DRZL" => array("probable drizzle","lightRainSnow"),"PROB. DRZ" => array("probable drizzle","lightRainSnow"),"PROB. SHWR" => array("probable showers","lightRainSnow"),"PROB. SHW" => array("probable showers","lightRainSnow"),"MOD. RAIN" => array("moderate rain","rain"),"HEAVY RAIN" => array("heavy rain","heavyRain"),"HEAVY RAI" => array("heavy rain","heavyRain"),"CH. RN/SNW" => array("chance of rain or snow","rainSnowChances"),"CH. RN/SN" => array("chance of rain or snow","rainSnowChances"),"CH. SNW/RN" => array("chance of snow or rain","rainSnowChances"),"CH. SNW/R" => array("chance of snow or rain","rainSnowChances"),"CHNC. SNOW" => array("chance of snow","snowChances"),"CHNC. SNO" => array("chance of snow","snowChances"),"LIGHT SNOW" => array("light snow","lightSnow"),"LIGHT SNO" => array("light snow","lightSnow"),"LT. RN/SNW" => array("light rain or snow","rainSnow"),"LT. RN/SN" => array("light rain or snow","rainSnow"),"LT. SNW/RN" => array("light snow or rain","rainSnow"),"LT. SNW/R" => array("light snow or rain","rainSnow"),"PR. RN/SNW" => array("probable rain or snow","rainSnow"),"PR. RN/SN" => array("probable rain or snow","rainSnow"),"PR. SNW/RN" => array("probable snow or rain","rainSnow"),"PR. SNW/R" => array("probable snow or rain","rainSnow"),"PROB. SNOW" => array("probable snow","rainSnow"),"PROB. SNO" => array("probable snow","rainSnow"),"PROB.SNOW" => array("probable snow","snow"),"MOD. SNOW" => array("moderate snow","snow"),"SN. FLURRY" => array("snow flurries","snow"),"SN. FLURR" => array("snow flurries","snow"),"RAIN/SNOW" => array("rain or snow","snow"),"SNOW/RAIN" => array("snow or rain","snow"),"HEAVY SNOW" => array("heavy snow","rainSnow"),"HEAVY SNO" => array("heavy snow","rainSnow"),"HVY.SNW/RN" => array("heavy snow or rain","heavySnow"),"HVY.SNW/R" => array("heavy snow or rain","heavySnow"),"HVY.RN/SNW" => array("heavy rain or snow","heavyRainSnow"),"HVY.RN/SN" => array("heavy rain or snow","heavyRainSnow"),"CH. FRZ.RN" => array("chance of freezing rain","heavyRainSnow"),"CH. FRZ.R" => array("chance of freezing rain","heavyRainSnow"),"CH. RN/SLT" => array("chance of rain or sleet","rainSnowChances"),"CH. RN/SL" => array("chance of rain or sleet","rainSnowChances"),"CH. SLT/FR" => array("chance of sleet","rainSnowChances"),"CH. SLT/F" => array("chance of sleet","rainSnowChances"),"CH.SLT/MIX" => array("chance of sleet or snow","lightRainChances"),"CH.SLT/MI" => array("chance of sleet or snow","lightRainChances"),"CH.SLT/SNW" => array("chance of sleet","rainSnowChances"),"CH.SLT/SN" => array("chance of sleet","rainSnowChances"),"CHNC.SLEET" => array("freezing drizzle","lightRainChances"),"CHNC.SLEE" => array("freezing rain","lightRainChances"),"FRZ. DRZL" => array("ice storm","rainSnow"),"FRZ. RAIN" => array("light sleet","rainSnow"),"ICE STORM" => array("light sleet","rainSnow"),"LT. SLEET" => array("light sleet","lightRainSnow"),"LT.SLT/MIX" => array("light sleet or snow","lightRainSnow"),"LT.SLT/MI" => array("light sleet or snow","lightRainSnow"),"LT.SLT/SNW" => array("light sleet or snow","rainSnow"),"LT.SLT/SN" => array("light sleet or snow","rainSnow"),"PR. FRZ.RN" => array("probable freezing rain","rainSnow"),"PR. FRZ.R" => array("probable freezing rain","rainSnow"),"PR. RN/SLT" => array("probable rain or sleet","rainSnow"),"PR. RN/SL" => array("probable rain or sleet","rainSnow"),"PR.SLT/MIX" => array("probable sleet","lightRainSnow"),"PR.SLT/MI" => array("probable sleet","lightRainSnow"),"PR.SLT/SNW" => array("probable sleet or snow","rainSnow"),"PR.SLT/SN" => array("probable sleet or snow","rainSnow"),"PR. SLT/FR" => array("probable sleet or freezing rain","rainSnow"),"PR. SLT/F" => array("probable sleet or freezing rain","rainSnow"),"PROB.SLEET" => array("probable sleet","lightRainSnow"),"PROB.SLEE" => array("probable sleet","lightRainSnow"),"MOD. SLEET" => array("moderate sleet","lightRainSnow"),"MOD. SLEE" => array("moderate sleet","lightRainSnow"),"RAIN/SLEET" => array("rain or sleet","rainSnow"),"RAIN/SLEE" => array("rain or sleet","rainSnow"),"SLEET/MIX" => array("sleet","rainSnow"),"SLEET/SNOW" => array("sleet or snow","rainSnow"),"SLEET/SNO" => array("sleet or snow","rainSnow"),"SLT/FRZ.RN" => array("sleet or freezing rain","rainSnow"),"SLT/FRZ.R" => array("sleet or freezing rain","rainSnow"),"BLIZZARD" => array("snow and blizzard","blizzard"),"HVY. SLEET" => array("heavy sleet","heavyRainSnow"),"HVY. SLEE" => array("heavy sleet","heavyRainSnow"),"HVY.SLT/MX" => array("heavy sleet","heavyRainSnow"),"HVY.SLT/M" => array("heavy sleet","heavyRainSnow"),"HVY.SLT/SN" => array("heavy sleet","heavyRainSnow"),"HVY.SLT/S" => array("heavy sleet","heavyRainSnow"),"LIGHT FOG" => array("light fog","clearHaze"),"MOD. FOG" => array("moderate fog","fog"),"DENSE FOG" => array("dense fog","fog"),"LIGHT DEW" => array("light dew","dew1"),"MOD. DEW" => array("moderate dew","dew2"),"HEAVY DEW" => array("heavy dew","dew3"),"SCTD.FROST" => array("scattered frost","frost1"),"SCTD.FROS" => array("scattered frost","frost1"),"LT. FROST" => array("light frost","frost1"),"MOD. FROST" => array("moderate frost","frost2"),"MOD. FROS" => array("moderate frost","frost2"),"HVY. FROST" => array("heavy frost","frost3"),"HVY. FROS" => array("heavy frost","frost3"));
		if (isset($condArray[$condition]))
		   return $condArray[$condition];
		else
		   return array($condition,"none");
		}
	function periodSumup($data){
		global $dataTempUnits;
		global $dataRainUnits;
		global $dataWindUnits;
		global $displayRainUnits;
		global $displayWindUnits;
		$dataTempUnits = trim($dataTempUnits);
		$dataRainUnits = trim($dataRainUnits);
		$dataWindUnits = trim($dataWindUnits);
		$Ts = array();
		$maxTs = array();
		$minTs = array();
		$Hs = array();
		$Ws = array();
		foreach($data as $dataRow){
			$Ts[] = $dataRow['Temperature'];
			$maxTs[] = $dataRow['Hi Temp'];
			$minTs[] = $dataRow['Low Temp'];
			$icons[] = $dataRow['icon'];
			$Hs[] = $dataRow['Rel.Hum.'];
			$Ws[] = $dataRow['Wind Spd.'];
		}
		$result['T'] = number_format(convertT(array_sum($Ts)/count($Ts)),0,".","");
		$result['Tmax'] = max($maxTs);
		$result['Tmin'] = min($minTs);
		if($displayRainUnits=="mm"){
			$result['rain'] = $data[count($data)-1]['Tot.Prcp'] - $data[0]['Tot.Prcp'];
			if($result['rain']<0){
				$result['rain'] = 0;
			}
			$result['rain'] = number_format($result['rain'],1,".","");
		}
		else{
			$result['rain'] = $data[count($data)-1]['Tot.Prcp'] - $data[0]['Tot.Prcp'];
			if($result['rain']<0){
				$result['rain'] = 0;
			}
			$result['rain'] = number_format($result['rain'],2,".","");
		}
		$result['H'] = number_format((array_sum($Hs)/count($Hs)),0,".","");
		$result['W'] = number_format(convertW(array_sum($Ws)/count($Ws)),1,".","");
		$countedIcons = array_count_values($icons);
		asort($countedIcons);
		end($countedIcons);
		$result['icon'] = key($countedIcons);
		return $result;
	}
?>
