<?php

	if($var=="T"){
		$heading = lang("temperature",'c');
		$mySQLCols = array("T","Tmax","Tmin");
		$colors['min'] = "#007FFF";
		$colors['max'] = "#D90000";
		$deviationsDecimals = 2;
		$dp = 1;
		$UoM = unitFormatter($displayTempUnits);
	}
	if($var=="A"){
		$heading = lang("apparent temperature",'c');
		$mySQLCols = array("A","A","A");
		$colors['min'] = "#007FFF";
		$colors['max'] = "#D90000";
		$deviationsDecimals = 2;
		$dp = 1;
		$UoM = unitFormatter($displayTempUnits);
	}
	if($var=="D"){
		$heading = lang("dew point",'c');
		$mySQLCols = array("D","D","D");
		$colors['min'] = "#007FFF";
		$colors['max'] = "#D90000";
		$deviationsDecimals = 2;
		$dp = 1;
		$UoM = unitFormatter($displayTempUnits);
	}
	if($var=="H"){
		$heading = lang("humidity",'c');
		$mySQLCols = array("H","H","H");
		$colors['min'] = "#d9a300";
		$colors['max'] = "#00b300";
		$deviationsDecimals = 1;
		$dp = 1;
		$UoM = "%";
	}
	if($var=="P"){
		$heading = lang("pressure",'c');
		$mySQLCols = array("P","P","P");
		$colors['min'] = "#ffa64c";
		$colors['max'] = "#a300d9";
		$deviationsDecimals = $decimalsP + 2;
		$dp = $decimalsP;
		$UoM = unitFormatter($displayPressUnits);
	}
	if($var=="W"){
		$heading = lang("wind speed",'c');
		$mySQLCols = array("W","W","W");
		$colors['min'] = "#aaaaaa";
		$colors['max'] = "#a300d9";
		$deviationsDecimals = 2;
		$dp = 1;
		$UoM = unitFormatter($displayWindUnits);
	}
	if($var=="G"){
		$heading = lang("wind gust",'c');
		$mySQLCols = array("G","G","G");
		$colors['min'] = "#aaaaaa";
		$colors['max'] = "#a300d9";
		$deviationsDecimals = 2;
		$dp = 1;
		$UoM = unitFormatter($displayWindUnits);
	}
	if($var=="S"){
		$heading = lang("solar radiation",'c');
		$mySQLCols = array("S","S","S");
		$colors['min'] = "#222222";
		$colors['max'] = "#ffd24c";
		$deviationsDecimals = 0;
		$dp = 0;
		$UoM = "W/m2";
	}
	if($var=="UV"){
		$heading = lang("UV",'c');
		$mySQLCols = array("UV","UV","UV");
		$colors['min'] = "#222222";
		$colors['max'] = "#ffd24c";
		$deviationsDecimals = 0;
		$dp = 1;
		$UoM = "";
	}
	if($var=="L"){
		$heading = lang("lightning",'c');
		$mySQLCols = array("L","L","L");
		$colors['min'] = "#222222";
		$colors['max'] = "#ffd24c";
		$deviationsDecimals = 0;
		$dp = 1;
		$UoM = "";
	}
	if($var=="R"){
		$heading = lang("precipitation",'c');
		$colors['min'] = "#999999";
		$colors['max'] = "#006cd9";
		$mySQLCols = array("R","R","R");
		if($displayRainUnits=="in"){
			$dp = 2;
		}
		else{
			$dp = 1;
		}
		$UoM = unitFormatter($displayRainUnits);
	}	
	if($var=="ET"){                 // extra parameter ET
		$heading = lang("evapotranspiration",'c');
		$mySQLCols = array("ET","ET","ET");
		$colors['min'] = "#999999";
		$colors['max'] = "#006cd9";
		$deviationsDecimals = 4;
		$dp = 3;
		$UoM = unitFormatter($displayRainUnits);
	}
	if(parameterLike($var,"T")){    // extra parameter T#
		$heading = lang("temperature",'c')." ".$var;
		$mySQLCols = array($var,$var,$var);
		$colors['min'] = "#007FFF";
		$colors['max'] = "#D90000";
		$deviationsDecimals = 2;
		$dp = 1;
		$UoM = unitFormatter($displayTempUnits);
	}
	if(parameterLike($var,"H")){    // extra parameter H#
		$heading = lang("humidity",'c')." ".$var;
		$mySQLCols = array($var,$var,$var);
		$colors['min'] = "#d9a300";
		$colors['max'] = "#00b300";
		$deviationsDecimals = 1;
		$dp = 1;
		$UoM = "%";
	}
	if(parameterLike($var,"SM")){    // extra parameter SM#
		$heading = lang("soil moisture",'c')." ".$var;
		$mySQLCols = array($var,$var,$var);
		$colors['min'] = "#d9a300";
		$colors['max'] = "#00b300";
		$deviationsDecimals = 1;
		$dp = 0;
		$UoM = "%";
	}
	if(parameterLike($var,"LW")){    // extra parameter LW#
		$heading = lang("leaf wetness",'c')." ".$var;
		$mySQLCols = array($var,$var,$var);
		$colors['min'] = "#d9a300";
		$colors['max'] = "#00b300";
		$deviationsDecimals = 1;
		$dp = 0;
		$UoM = "%";
	}
	if(parameterLike($var,"TS")){    // extra parameter TS#
		$heading = lang("soil temperature",'c')." ".$var;
		$mySQLCols = array($var,$var,$var);
		$colors['min'] = "#007FFF";
		$colors['max'] = "#D90000";
		$deviationsDecimals = 2;
		$dp = 1;
		$UoM = unitFormatter($displayTempUnits);
	}
	if(parameterLike($var,"PP")){    // extra parameter PP#
		$heading = lang("particulate pollution",'c')." ".$var;
		$mySQLCols = array($var,$var,$var);
		$colors['min'] = "#d9a300";
		$colors['max'] = "#00b300";
		$deviationsDecimals = 1;
		$dp = 1;
		$UoM = "ug/m3";
	}
	if(parameterLike($var,"CO2_")){    // extra parameter CO2_#
		$heading = lang("carbon dioxide",'c')." ".$var;
		$mySQLCols = array($var,$var,$var);
		$colors['min'] = "#d9a300";
		$colors['max'] = "#00b300";
		$deviationsDecimals = 1;
		$dp = 1;
		$UoM = "ppm";
	}
	if(parameterLike($var,"SO2_")){    // extra parameter SO2_#
		$heading = lang("sulfur dioxide",'c')." ".$var;
		$mySQLCols = array($var,$var,$var);
		$colors['min'] = "#d9a300";
		$colors['max'] = "#00b300";
		$deviationsDecimals = 1;
		$dp = 1;
		$UoM = "ppb";
	}
	if(parameterLike($var,"NO2_")){    // extra parameter SO2_#
		$heading = lang("nitrogen dioxide",'c')." ".$var;
		$mySQLCols = array($var,$var,$var);
		$colors['min'] = "#d9a300";
		$colors['max'] = "#00b300";
		$deviationsDecimals = 1;
		$dp = 1;
		$UoM = "ppm";
	}
	if(parameterLike($var,"CO_")){    // extra parameter CO_#
		$heading = lang("carbon monoxide",'c')." ".$var;
		$mySQLCols = array($var,$var,$var);
		$colors['min'] = "#d9a300";
		$colors['max'] = "#00b300";
		$deviationsDecimals = 1;
		$dp = 1;
		$UoM = "ppm";
	}
	if(parameterLike($var,"O3_")){    // extra parameter O3_#
		$heading = lang("ozone",'c')." ".$var;
		$mySQLCols = array($var,$var,$var);
		$colors['min'] = "#d9a300";
		$colors['max'] = "#00b300";
		$deviationsDecimals = 1;
		$dp = 1;
		$UoM = "ppb";
	}
	
	function chooseConvertor($value){
		global $var;
		global $displayTempUnits;
		if($var=="T" || $var=="A" || $var=="D")
		    {return convertT($value);}
		else if ( parameterLike($var,"T") || parameterLike($var,"TS") )
		    {return convertor($value,"c",$displayTempUnits);}
		else if($var=="P")
		    {return convertP($value);}
		else if($var=="W" || $var=="G")
		    {return convertW($value);}
		else if($var=="R")
		    {return convertR($value);}
		else if($var=="ET")
		    {return convertR($value);}
		else
		    {return ($value);}
	}

// fixed par + number
// $par = T1 $like = T -> true
function parameterLike( $par, $like )
    {
    $a = strlen($like);
    if ( strlen($par) > $a )
        {
        if (substr($par,0,$a) == $like)
            {
            $b = substr($par,$a);
            if ($b == intval($b))
                {return true;}
            else
                {return false;}
            }
        else
            {return false;}
        }
    else
        {return false;}
    }
    
function parameterExtra( $par )
    {
    //echo "$par<br>";
    $alldataFields = ['T' => 1, 'Tmax' => 1, 'Tmin' => 1, 'H' => 1, 'A' => 1, 'D' => 1, 'W' => 1, 'G' => 1, 'B' => 1, 'RR' => 1, 'R' => 1, 'P' => 1, 'S' => 1];
    if (!isset($alldataFields[$par])) {return true;};
	return false;
    }
	
	