<?php

	############################################################################
	# 	
	#	Meteotemplate
	# 	http://www.meteotemplate.com
	# 	Free website template for weather enthusiasts
	# 	Author: Jachym
	#           Brno, Czech Republic
	# 	First release: 2015
	#
	############################################################################
	#
	#	CSV data export
	#
	# 	A script which triggers CSV export of user specified data.
	#
	############################################################################
	#	
	#
	# 	v17.2 Nectarine 2019-06-27
	#
	############################################################################
	
	// output headers so that the file is downloaded rather than displayed
	header('Content-Type: text/csv; charset=utf-8');
	header('Content-Disposition: attachment; filename=data.csv');

	$value = $_GET['value'];
	$interval = $_GET['interval'];
	$parametersFull = $_GET['parameters'];
	$parametersFull = str_replace("bracketL","(",$parametersFull);
	$parametersFull = str_replace("bracketR",")",$parametersFull);
	$parameters = explode(",",$parametersFull);
		
	if($parametersFull==""){
		die();
	}
		
	if($interval=="custom"){
		$from = $_GET['from'];
		$to = $_GET['to'];
		$checkFrom = strtotime($from);
		if(date('Y',$checkFrom)<1900 || date('Y',$checkFrom)>2100){
			die();		
		}
		$checkTo = strtotime($to);
		if(date('Y',$checkTo)<1900 || date('Y',$checkTo)>2100){
			die();		
		}
	}
	

	include("../../config.php");
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);
	include("../../scripts/functions.php");

	// create a file pointer connected to the output stream
	$output = fopen('php://output', 'w');

	// print "\xEF\xBB\xBF"; // fix encoding

	$columns = array();
	array_push($columns,"Date");
	array_push($columns,"Time");



	if($value=="all"){
		$grouping = "YEAR(alldata.DateTime), MONTH(alldata.DateTime), DAY(alldata.DateTime), HOUR(alldata.DateTime), MINUTE(alldata.DateTime)";
	}
	if($value=="h"){
		$grouping = "YEAR(alldata.DateTime), MONTH(alldata.DateTime), DAY(alldata.DateTime), HOUR(alldata.DateTime)";
	}
	if($value=="d"){
		$grouping = "YEAR(alldata.DateTime), MONTH(alldata.DateTime), DAY(alldata.DateTime)";
	}
	if($value=="m"){
		$grouping = "YEAR(alldata.DateTime), MONTH(alldata.DateTime)";
	}
	
	if($interval == "1h"){
		$span = "WHERE alldata.DateTime >= now() - interval 1 hour";
	}
	if($interval == "today"){
		$span = "WHERE DATE(alldata.DateTime) = CURDATE()";
	}
	if($interval == "24h"){
		$span = "WHERE alldata.DateTime >= now() - interval 24 hour";
	}
	if($interval == "yesterday"){
		$span = "WHERE DATE(alldata.DateTime) = CURDATE() - INTERVAL 1 DAY";
	}
	if($interval == "thisweek"){ // here we have to consider whether user wants Sunday or Monday as first day of the week - set in config file
		$span = "WHERE YEARWEEK(alldata.DateTime,$firstWeekday) = YEARWEEK(CURDATE(),$firstWeekday)";
	}
	if($interval == "lastweek"){
		$span = "WHERE YEARWEEK(alldata.DateTime,$firstWeekday) = (YEARWEEK(CURDATE(),$firstWeekday)-1)";
	}
	if($interval == "thismonth"){
		$span = "WHERE YEAR(alldata.DateTime) = YEAR(CURDATE()) AND MONTH(alldata.DateTime) = MONTH(CURDATE())";
	}
	if($interval == "lastmonth"){
		$span = "WHERE YEAR(alldata.DateTime) = YEAR(CURRENT_DATE - INTERVAL 1 MONTH) AND MONTH(alldata.DateTime) = MONTH(CURRENT_DATE - INTERVAL 1 MONTH)";
	}
	
	if($interval == "custom"){
		$span = "WHERE alldata.DateTime >= '$from' AND alldata.DateTime <= '$to'";
	}

	for($i=0;$i<count($parameters);$i++){
		switch($parameters[$i]){
			case "avg(T)":
				array_push($columns,lang("temperature",'c')." - ".lang('avgAbbr','c')." (".$displayTempUnits.")");
				break;
			case "avg(H)":
				array_push($columns,lang("humidity",'c')." - ".lang('avgAbbr','c')." (%)");
				break;
			case "avg(P)":
				array_push($columns,lang("pressure",'c')." - ".lang('avgAbbr','c')." (".$displayPressUnits.")");
				break;
			case "avg(W)":
				array_push($columns,lang("wind speed",'c')." - ".lang('avgAbbr','c')." (".$displayWindUnits.")");
				break;
			case "avg(G)":
				array_push($columns,lang("wind gust",'c')." - ".lang('avgAbbr','c')." (".$displayWindUnits.")");
				break;
			case "avg(B)":
				array_push($columns,lang("wind direction",'c')." - ".lang('all','c')." (°)");
				break;
			case "avg(S)":
				array_push($columns,lang("solar radiation",'c')." - ".lang('avgAbbr','c')." (W/m2)");
				break;
			case "avg(D)":
				array_push($columns,lang("dew point",'c')." - ".lang('avgAbbr','c')." (".$displayTempUnits.")");
				break;
			case "avg(A)":
				array_push($columns,lang("apparent temperature",'c')." - ".lang('avgAbbr','c')." (".$displayTempUnits.")");
				break;
			case "avg(RR)":
				array_push($columns,lang("rain rate",'c')." - ".lang('avgAbbr','c')." (".$displayRainUnits."/h)");
				break;
			case "avg(L)":
				array_push($columns,lang("lightning",'c')." - ".lang('avgAbbr','c'));
				break;
			case "max(Tmax)":
				array_push($columns,lang("temperature",'c')." - ".lang('maximumAbbr','c')." (".$displayTempUnits.")");
				break;
			case "max(H)":
				array_push($columns,lang("humidity",'c')." - ".lang('maximumAbbr','c')." (%)");
				break;
			case "max(P)":
				array_push($columns,lang("pressure",'c')." - ".lang('maximumAbbr','c')." (".$displayPressUnits.")");
				break;
			case "max(W)":
				array_push($columns,lang("wind speed",'c')." - ".lang('maximumAbbr','c')." (".$displayWindUnits.")");
				break;
			case "max(G)":
				array_push($columns,lang("wind gust",'c')." - ".lang('maximumAbbr','c')." (".$displayWindUnits.")");
				break;
			case "max(S)":
				array_push($columns,lang("solar radiation",'c')." - ".lang('maximumAbbr','c')." (W/m2)");
				break;
			case "max(D)":
				array_push($columns,lang("dew point",'c')." - ".lang('maximumAbbr','c')." (".$displayTempUnits.")");
				break;
			case "max(A)":
				array_push($columns,lang("apparent temperature",'c')." - ".lang('maximumAbbr','c')." (".$displayTempUnits.")");
				break;
			case "max(RR)":
				array_push($columns,lang("rain rate",'c')." - ".lang('maximumAbbr','c')." (".$displayRainUnits."/h)");
				break;
			case "max(ET)":
				array_push($columns,lang("evapotranspiration",'c')." - ".lang('maximumAbbr','c')." (".$displayRainUnits.")");
				break;
			case "max(L)":
				array_push($columns,lang("lightning",'c')." - ".lang('maximumAbbr','c'));
				break;
			case "min(Tmin)":
				array_push($columns,lang("temperature",'c')." - ".lang('minimumAbbr','c')." (".$displayTempUnits.")");
				break;
			case "min(H)":
				array_push($columns,lang("humidity",'c')." - ".lang('minimumAbbr','c')." (%)");
				break;
			case "min(P)":
				array_push($columns,lang("pressure",'c')." - ".lang('minimumAbbr','c')." (".$displayPressUnits.")");
				break;
			case "min(W)":
				array_push($columns,lang("wind speed",'c')." - ".lang('minimumAbbr','c')." (".$displayWindUnits.")");
				break;
			case "min(G)":
				array_push($columns,lang("wind gust",'c')." - ".lang('minimumAbbr','c')." (".$displayWindUnits.")");
				break;
			case "min(S)":
				array_push($columns,lang("solar radiation",'c')." - ".lang('minimumAbbr','c')." (W/m2)");
				break;
			case "min(D)":
				array_push($columns,lang("dew point",'c')." - ".lang('minimumAbbr','c')." (".$displayTempUnits.")");
				break;
			case "min(A)":
				array_push($columns,lang("apparent temperature",'c')." - ".lang('minimumAbbr','c')." (".$displayTempUnits.")");
				break;
			case "min(RR)":
				array_push($columns,lang("rain rate",'c')." - ".lang('minimumAbbr','c')." (".$displayRainUnits."/h)");
				break;
			case "min(L)":
				array_push($columns,lang("lightning",'c')." - ".lang('minimumAbbr','c'));
				break;
			case "max(Tmax)-min(Tmin)":
				array_push($columns,lang("temperature",'c')." - ".lang('range','c')." (".$displayTempUnits.")");
				break;
			case "max(H)-min(H)":
				array_push($columns,lang("humidity",'c')." - ".lang('range','c')." (%)");
				break;
			case "max(P)-min(P)":
				array_push($columns,lang("pressure",'c')." - ".lang('range','c')." (".$displayPressUnits.")");
				break;
			case "max(W)-min(W)":
				array_push($columns,lang("wind speed",'c')." - ".lang('range','c')." (".$displayWindUnits.")");
				break;
			case "max(G)-min(G)":
				array_push($columns,lang("wind gust",'c')." - ".lang('range','c')." (".$displayWindUnits.")");
				break;
			case "max(R)-min(R)":
				array_push($columns,lang("Precipitation")." - ".lang('total','c')." (".$displayRainUnits.")");
				break;
			case "max(S)-min(S)":
				array_push($columns,lang("solar radiation",'c')." - ".lang('range','c')." (W/m2)");
				break;
			case "max(D)-min(D)":
				array_push($columns,lang("dew point",'c')." - ".lang('range','c')." (".$displayTempUnits.")");
				break;
			case "max(A)-min(A)":
				array_push($columns,lang("apparent temperature",'c')." - ".lang('range','c')." (".$displayTempUnits.")");
				break;
			case "max(RR)-min(RR)":
				array_push($columns,lang("rain rate",'c')." - ".lang('range','c')." (".$displayRainUnits."/h)");
				break;
			default:
		}
	}
	
	fputcsv($output, $columns, ';', ' ');

	$possibleParameters = array("avg(T)","avg(H)","avg(P)","avg(W)","avg(G)","avg(B)","avg(S)","avg(D)","avg(A)","max(Tmax)","max(H)","max(P)","max(W)","max(G)","max(S)","max(D)","max(A)","min(Tmin)","min(H)","min(P)","min(W)","min(G)","min(S)","min(D)","min(A)","max(Tmax)-min(Tmin)","max(H)-min(H)","max(P)-min(P)","max(W)-min(W)","max(G)-min(G)","max(S)-min(S)","max(D)-min(D)","max(A)-min(A)","max(R)","R","min(R)","max(R)-min(R)","avg(RR)","max(RR)","min(RR)","max(RR)-min(RR)");
	$possibleParametersExtra = array("avg(ET)","avg(L)","max(ET)","max(L)","min(ET)","min(L)");
	$parametersOriginal = $parameters;
	$parameters = array();
	$includeExtra = false;
	
	for($i=0;$i<count($parametersOriginal);$i++){
		if(in_array(trim($parametersOriginal[$i]),$possibleParameters))
		    {$parameters[] = $parametersOriginal[$i];}
		else if(in_array(trim($parametersOriginal[$i]),$possibleParametersExtra))
		    {$parameters[] = $parametersOriginal[$i]; $includeExtra = true;}
	}
	$parametersFull = implode(", ",$parameters);

	// first make a fix for the rain - we need to calculate the daily values and them sum those
	$monthlySum = array();
	$a = mysqli_query($con,
		"
		SELECT alldata.DateTime, max(R), MONTH(alldata.DateTime)
		FROM alldata 
		$span
		GROUP BY Year(alldata.DateTime), Month(alldata.DateTime), Day(alldata.DateTime)
		ORDER BY alldata.DateTime
		"
	);
	$current = "";
	while($row = mysqli_fetch_array($a)){
		if($current==""){
			$current = convertR($row['max(R)']);
			$currentMonth = $row['MONTH(alldata.DateTime)'];
		}
		else{
			if($row['MONTH(alldata.DateTime)']==$currentMonth){
				$current += convertR($row['max(R)']);
			}
			else{
				array_push($monthlySum, $current);
				$currentMonth = $row['MONTH(alldata.DateTime)'];
				$current = convertR($row['max(R)']);
			}
		}
	}
		
	array_push($monthlySum, $current);

	if ($includeExtra)
	    {
		/*echo "SELECT alldata.DateTime, $parametersFull, R
			FROM alldata INNER JOIN alldataExtra ON alldata.DateTime=alldataExtra.DateTime
			$span
			GROUP BY $grouping
			ORDER BY alldata.DateTime";*/

		$x = mysqli_query($con,
		    "
			SELECT alldata.DateTime, $parametersFull, R
			FROM alldata INNER JOIN alldataExtra ON alldata.DateTime=alldataExtra.DateTime
			$span
			GROUP BY $grouping
			ORDER BY alldata.DateTime
			");
		}
	else
	    {
		/*echo "SELECT alldata.DateTime, $parametersFull, R
			FROM alldata
			$span
			GROUP BY $grouping
			ORDER BY alldata.DateTime";*/
		$x = mysqli_query($con,
		    "
			SELECT alldata.DateTime, $parametersFull, R
			FROM alldata
			$span
			GROUP BY $grouping
			ORDER BY alldata.DateTime
			");
		}

	while($row = mysqli_fetch_array($x)){
      	if ( ( count($parameters) == 1) && ($parameters[0]=="max(ET)")  && is_null($row[$parameters[0]]) )  continue;
		$rowData = array();
		$currentDate = date_create($row['DateTime']);
		if($value=="all"){
			array_push($rowData,date_format($currentDate,$dateFormat));
			array_push($rowData,date_format($currentDate,$timeFormat));
		}
		if($value=="h"){
			array_push($rowData,date_format($currentDate,$dateFormat));
			array_push($rowData,date_format($currentDate,$timeFormat));
		}
		if($value=="d"){
			array_push($rowData,date_format($currentDate,$dateFormat));
			array_push($rowData," ");
		}
		if($value=="m"){
			array_push($rowData,date_format($currentDate,'m / Y'));
			array_push($rowData," ");
		}
		
		for($i=0;$i<count($parameters);$i++){
			if($parameters[$i]=="avg(T)" || $parameters[$i]=="max(Tmax)" || $parameters[$i]=="min(Tmin)" || $parameters[$i]=="max(Tmax)-min(Tmin)" || $parameters[$i]=="avg(A)" || $parameters[$i]=="max(A)" || $parameters[$i]=="min(A)" || $parameters[$i]=="max(A)-min(A)" || $parameters[$i]=="avg(D)" || $parameters[$i]=="max(D)" || $parameters[$i]=="min(D)" || $parameters[$i]=="max(D)-min(D)"){
				$resultValue = convertT($row[$parameters[$i]]);
				array_push($rowData,number_format($resultValue,2,".",''));
			}
			else if($parameters[$i]=="avg(W)" || $parameters[$i]=="max(W)" || $parameters[$i]=="min(W)" || $parameters[$i]=="max(W)-min(W)" || $parameters[$i]=="avg(G)" || $parameters[$i]=="max(G)" || $parameters[$i]=="min(G)" || $parameters[$i]=="max(G)-min(G)"){
				$resultValue = convertW($row[$parameters[$i]]);
				array_push($rowData,number_format($resultValue,2,".",''));
			}
			else if($parameters[$i]=="avg(P)" || $parameters[$i]=="max(P)" || $parameters[$i]=="min(P)" || $parameters[$i]=="max(P)-min(P)"){
				$resultValue = convertP($row[$parameters[$i]]);
				array_push($rowData,number_format($resultValue,2,".",''));
			}
			else if($parameters[$i]=="max(R)-min(R)"){
				if($value=="all"){
					$resultValue = convertR($row['R']);
					array_push($rowData,number_format($resultValue,2));
				} // rain total from one measurement is nonsense
				else if($value=="m"){
					array_push($rowData,number_format($monthlySum[$i],2,".",'')); // in this case insert previously calculated fix for monthly rain sum
				}
				else{
					$resultValue = convertR($row[$parameters[$i]]);
					array_push($rowData,number_format($resultValue,2,".",''));
				}
			}
			else if($parameters[$i]=="avg(B)"){
				$resultValue = $row[$parameters[$i]];
				array_push($rowData,number_format($resultValue,0,".",''));	
			}
			else if($parameters[$i]=="avg(RR)" || $parameters[$i]=="max(RR)" || $parameters[$i]=="min(RR)" || $parameters[$i]=="max(RR)-min(RR)" || $parameters[$i]=="max(ET)"){
				$resultValue = convertR($row[$parameters[$i]]);
				array_push($rowData,number_format($resultValue,2,".",''));
			}
			else{
				$resultValue = $row[$parameters[$i]];
				//echo "resultValue=$resultValue  row[parameter]=".$row[$parameters[$i]]."<br>";
				array_push($rowData,number_format($resultValue,2,".",""));
			}
		}
		fputcsv($output, $rowData, ';', ' ');
	}
?>